//
//  MCLogger.h
//  MCFoundation
//
//  Created by aj on Thu Sep 06 2001.
//  Copyright (c) 2001 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

/*

Purpose: Logs messages using NSLog, but checks the defaults database whether it should be: 1) not logging 2) pass everything through 3) log for specific classes
Default behavior is no logging.


Defaults
    MCLoggerStyle	// NoLogging, LogForClass, LogAll
    MCLoggerClassnames	// expects NSArray of strings


*/

#define		NO_LOGGING	0
#define		LOG_FOR_CLASS	1
#define		LOG_ALL		2


@interface MCLogger : NSObject {
    NSSet	*validClassnames;
    int		loggingStyle;

}

+ (MCLogger *)defaultLogger;

// Returns YES if LOG_FOR_CLASS or LOG_ALL
- (BOOL)isLogging;


- (void)logForObject:(id)anObject message:(NSString *)aString;
- (void)logForObject:(id)anObject messageFormat:(NSString *)format, ...;

@end


@interface NSObject (MCLogger)
+ (void)log:(NSString *)format, ...;
- (void)log:(NSString *)format, ...;

@end
